
# Redact

> [!NOTE]
> All of our free software is designed to respect your privacy, while being as simple to use as possible. Our free software is licensed under the [BSD-3-Clause license](https://ravendevteam.org/files/BSD-3-Clause.txt/). By using our software, you acknowledge and agree to the terms of the license.

> [!NOTE]
> This software has a paid variant for enterprise use, designed for mass deployment, usable via the command-line. For more information, visit the [software page](https://ravendevteam.org/software/redact/).

File shredder with a focus on simplicity and security.

Made for Windows 10/11.

## Features
- Simple UI: Fast and easy to use.
- Drag, select, shred: Miminum technical knowledge is needed.
- Bulk shredding: Shred entire folders and bulk amounts of data.
- No bloat: No excessive features, ads, or extra nonsense. Just a simple shredder.
- Individual or business use: Uses industry best practices for shredding.

## Installation
See [Releases](https://github.com/ravendevteam/redact/releases). Download the latest version.

To compile from source, make sure you have Python 3.12.4 or greater, and Nuitka, then run `build.bat`.

## Personalize The Application

To personalize the application, create **rdstyle.css** in your user folder (*ex: C:\Users\Paul\rdstyle.css*). Edit the file to include any CSS styling you want, save your changes, then restart Redact. If done correctly, it should load your custom styling.

> [!NOTE]
> Redact's UI is built with Qt5 (*PyQt5, to be specific*). You can read the documentation for Qt5 CSS styling [here](https://doc.qt.io/qt-5/stylesheet-syntax.html).

## Authors & Contributors

- [Raven Development Team](https://ravendevteam.org/)
- [Icons by Icons8](https://icons8.com/)
