<p align="center">
  <img src="banner.png" alt="Banner" width="800">
</p>

> [!NOTE]
> All of our free software is designed to respect your privacy, while being as simple to use as possible. Our free software is licensed under the [BSD-3-Clause license](https://ravendevteam.org/files/BSD-3-Clause.txt). By using our software, you acknowledge and agree to the terms of the license.

A terminal multiplexer with tabs, autocomplete, and more.

Made for Windows 11 and Linux.

## Installation
You can download Poly [here](https://ravendevteam.org/software/poly).

To compile from source, make sure you have Python 3.12.4 and Nuitka. Install the necessary dependencies from `requirements.txt`, then run the `build.bat` or `build.sh` script based on your platform.

## Features & Usage
- **.polyrc:** Create a .polyrc file in your home directory to define initial commands to execute.
- **Poly shell:** Poly has its own command set and autocomplete. You can set variables using `variable <name> <value>`, and utilize them by enclosing in curly brackets, like `{name}`. There are preset variables as well, like `{username}`, `{computer}`, and `{cwd}`. You can write custom scripts with the `.poly` file extension and execute them with Poly. You can chain multiple commands by adding a `&&`, like doing `echo Hello, && echo World!`.
- **Tabs:** Poly has tabs for running multiple shell sessions at once.
- **Tab modes:** You can set the mode of your current tab to switch from the Poly shell to Command Prompt, Powershell, or your preferred Linux shell, using `tab mode <win|pws|lnx>`.
- **Creating a new tab:** CTRL + T
- **Closing current tab:** CTRL + W
- **Switching to next tab:** Tab
- **Switching to previous tab:** Shift + Tab

## Screenshots

![Demo Screenshot 1](https://raw.githubusercontent.com/ravendevteam/poly/refs/heads/main/demo_screenshot_1.png)

## Authors & Contributors

- [Raven Development Team](https://ravendevteam.org/)
- [Icons by Icons8](https://icons8.com/)
- [lilafian](https://github.com/lilafian)
- [swordmasterliam](https://github.com/swordmasterliam)
- [rhhen122](https://github.com/rhhen122)
- [mre31](https://github.com/mre31)
