const use24Time = false;

function updateTime() {
	const timeDiv = document.querySelector('.time');
	if (!timeDiv) return;

	const now = new Date();
	let hours = now.getHours();
	let minutes = now.getMinutes().toString().padStart(2, '0');
	let seconds = now.getSeconds().toString().padStart(2, '0');

	let formattedTime;

	if (use24Time) {
		formattedTime = `${hours.toString().padStart(2, '0')}:${minutes}:${seconds}`;
	} else {
		const ampm = hours >= 12 ? 'PM' : 'AM';
		hours = hours % 12 || 12;
		formattedTime = `${hours.toString().padStart(2, '0')}:${minutes}:${seconds} ${ampm}`;
	}

	timeDiv.textContent = formattedTime;
}

updateTime();
setInterval(updateTime, 1000);