const SEARCH_PROVIDER_BASE = 'https://searx.stream/search';
const searchBox = document.getElementById('searchBox');
if (searchBox) {
    searchBox.addEventListener('keypress', event => {
        if (event.key === 'Enter') {
            event.preventDefault();
            const inputValue = event.target.value.trim();
            window.location.href = constructNavigationUrl(inputValue);
        }
    });
}
const domainPattern = /^(?=.{1,253}$)(?:[A-Za-z0-9](?:[A-Za-z0-9-]{0,61}[A-Za-z0-9])?\.)+[A-Za-z]{2,63}$/;
const ipPattern     = /^(?:\d{1,3}\.){3}\d{1,3}$/;
function isValidWebAddress(input) {
    if (/^https?:\/\//i.test(input)) {
        try {
            const url = new URL(input);
            return domainPattern.test(url.hostname) || ipPattern.test(url.hostname);
        } catch {
            return false;
        }
    }
    const [hostname] = input.split('/');
    return domainPattern.test(hostname) || ipPattern.test(hostname);
}
function constructNavigationUrl(input) {
    if (isValidWebAddress(input)) {
        return /^https?:\/\//i.test(input)
            ? input
            : `https://${input}`;
    }
    return `${SEARCH_PROVIDER_BASE}?q=${encodeURIComponent(input)}`;
}