const searchBox = document.getElementById('searchBox');

if (searchBox) {
    searchBox.addEventListener('keypress', event => {
        if (event.key === 'Enter') {
            event.preventDefault();
            const inputValue = event.target.value.trim();
            window.location.href = constructNavigationUrl(inputValue);
        }
    });
}
function isValidWebAddress(input) {
    try {
        new URL(input);
        return true;
    } catch {
        try {
            new URL(`https://${input}`);
            return true;
        } catch {
            return false;
        }
    }
}
function constructNavigationUrl(input) {
    if (isValidWebAddress(input)) {
        return /^https?:\/\//i.test(input)
            ? input
            : `https://${input}`;
    }
    return `https://duckduckgo.com/?q=${encodeURIComponent(input)}`;
}