async function loadNews() {
    const newsContainer = document.getElementById("newsContent");
    try {
        const response = await fetch("https://newtab.ravendevteam.org/files/feed.md");
        if (!response.ok) throw new Error("Failed to fetch news.");
        const markdown = await response.text();
        newsContainer.innerHTML = marked.parse(markdown);
    } catch (error) {
        newsContainer.innerHTML = `<p style="color: red;">Error loading news: ${error.message}</p>`;
    }
}
document.addEventListener("DOMContentLoaded", loadNews);