@echo off
set FileVersion=1.0.0.0
set ProductVersion=1.3.0.0

:: Clean existing if any, obtain, unpack, and prepare VLC dependencies to be packaged.
rmdir /s /q build_temp 2>nul
mkdir build_temp
powershell -Command "Invoke-WebRequest 'https://download.videolan.org/pub/videolan/vlc/3.0.18/win64/vlc-3.0.18-win64.zip' -OutFile 'build_temp\\vlc.zip' -UseBasicParsing"
powershell -Command "Expand-Archive -Path 'build_temp\\vlc.zip' -DestinationPath 'build_temp\\extracted' -Force"
for /D %%D in (build_temp\extracted\*) do (
  if exist "%%D\libvlc.dll" set "VLCROOT=%%~fD"
)
mkdir build_temp\vlc
xcopy /E /I "%VLCROOT%\*" build_temp\vlc >nul

python -m nuitka --onefile --standalone --enable-plugins=pyqt5 --remove-output --windows-console-mode=disable --output-dir=dist --output-filename=Amp.exe --follow-imports --windows-icon-from-ico=ICON.ico --include-data-files=style.css=style.css --include-data-dir=media=media --output-dir=dist --include-data-files=amp.png=amp.png --include-data-files="build_temp\vlc=vlc\=**\*.dll" --product-name="Amp" --company-name="Raven Development Team" --file-description="Music player with a focus on simplicity and efficiency." --file-version=%FileVersion% --product-version=%ProductVersion% --copyright="Copyright (c) 2025 Raven Development Team" --onefile-tempdir-spec="{CACHE_DIR}\RavenDevelopmentTeam\Amp\{VERSION}" amp.py
pause